//******************************************
//           This is a C Template file
//
//
//
//ע
//******************************************
#include "MQ6822.h"
#include "iApp.h"
#include "OPmode.h"


//	delay_times(t_1ms, 100);	//  Normal mode, Slow mode
//void delay_times(uchar tBase, uint x);	//  Normal mode, Slow mode
//.....................|...........| x: 趨ӳʱ
//.....................| tBase: 趨ӳٵλ: t_1ms/t_100us ...
const uchar t_1ms   = 0;
const uchar t_100us = 1;


//*********************************************************************
// 	: SYSTEM_INIT()
// 	: IO, CGCR ʼ P10/P40/P41 ڷʱ֮趨
// ע		:
//*********************************************************************
void SYSTEM_INIT()
{
//-----Disable P10 Reset-----P10趨ΪһIO
//	SYSCR3.byte = 0x01;		// SYSCR3.bit.b0=1: P10趨ΪһIO, SYSCR3.bit.b0=0(Ԥֵ): P10Ϊ Reset Pin
//	SYSCR4.byte = 0xB2;		// 0xB2:  SYSCR3.bit.b0 ֮趨ֵ

//-----ʼ IO 
	P0DR.byte = 0x00;
	P0CR.byte = 0xff;
	P1DR.byte = 0x00;
	P1CR.byte = 0xff;
	P2DR.byte = 0x00;
	P2CR.byte = 0xff;
	P4DR.byte = 0x00;
	P4CR.byte = 0xff;
	P7DR.byte = 0x00;
	P7CR.byte = 0xff;
	P8DR.byte = 0x00;
	P8CR.byte = 0xff;
	P9DR.byte = 0x00;
	P9CR.byte = 0xff;
//	look_data(IRSTSR.byte);			// IRSTSR: ڲظλ״̬Ĵ
	WDCDR.byte = 0x4e;				// clear wdt


#ifdef _DEBUG	//...  _DEBUG: ڷ ev board
//------------------------------------------------------------------
//	ʱP10趨ΪReset Pin(ϵͳĬ)
//	ԱӰ漰¼.
	SYSCR3.byte   = 0x00;	// SYSCR3.bit.b0=1: P10趨ΪһIO, SYSCR3.bit.b0=0(Ԥֵ): P10Ϊ Reset Pin
	SYSCR4.byte   = 0xB2;	// 0xB2:  SYSCR3.bit.b0 ֮趨ֵ
//------------------------------------------------------------------
//	 P10/P40/P41  Debug modeڷʱ趨Ϊ룬
//	ԱӰ漰¼.
	P1CR.bit.b0   = 0;		// P10
	P4CR.bit.b0   = 0;		// P40
	P4CR.bit.b1   = 0;		// P41
//------------------------------------------------------------------
	FSCTRL.bit.b0 = 0;		// 0ΪĬֵڷģʽֶΪ0
//------------------------------------------------------------------
#endif


//	============================================
//	Set CGCR						;MQ6822 fc = 16MHz
//	============================================
	__asm("LD	(_CGCR),0x00");	//00 => fc/4 =  4Mhz(ϵͳĬ)
//	__asm("LD	(_CGCR),0x01");	//01 => fc/2 =  8Mhz
//	__asm("LD	(_CGCR),0x02");	//02 => fc   = 16Mhz
//	__asm("LD	(_CGCR),0x03");	//03 => fc/8 =  2Mhz
//**********************************************
//	Don't change CGCR<FCGCKSEL> in the SLOW mode
//**********************************************

//	ⲿپִд˳
#ifdef XTAL_High	//...  XTAL_High: ⲿپ
	XTAL_High_Config();
#endif

}


//*********************************************************************
// 	: delay_times(uchar tBase, uint x)
// 	: ʱ
// ע		: ==> t_1ms   = 0;
// 			: ==> t_100us = 1;
// 			: ...
//*********************************************************************
void delay_times(uchar tBase, uint x)
{
	uint  i, cgcrT;
//	uchar cgcrF[4]={ 2, 4,  8, 1 };	// HIRC =>  8MHz
	uchar cgcrF[4]={ 4, 8, 16, 2 };	// HIRC => 16MHz

//	...... ...... ...... delay for HIRC ...... ...... ......
	if( SYSCR2.bit.b4 == 0 )
	{
		cgcrT = cgcrF[CGCR.byte];		//0:fc/4, 1:fc/2, 2:fc/1, 3:fc/8
		switch(tBase){
			case 0:		// t_1ms
				cgcrT *= 110;
				for(; x>0; x--)
					for(i=0; i<cgcrT; i++){}
				break;
			case 1:		// t_100us
				cgcrT *= 11;
				for(; x>0; x--)
					for(i=0; i<cgcrT; i++){}
				break;
		}
	}
//	...... ...... ...... delay for LIRC ...... ...... ......
	else for(; x>0; x--){}

	WDCDR.byte=0x4e; 			//clear wdt
}




//*********************************************************************
// 	: look_data()
// 	: IO output data by IO_i2c
// ע		:
//*********************************************************************
void look_data(uchar data)
{
	uchar iloop, x, z=10;

	look_SDA_cr = 1;	// setting output port
	look_SCL_cr = 1;	// setting output port

//	start condition......
	look_SDA = 1;		for(x=z; x>0; x--){}
	look_SCL = 1;		for(x=z; x>0; x--){}
	look_SDA = 0;		for(x=z; x>0; x--){}
	look_SCL = 0;		for(x=z; x>0; x--){}

//	sent byte data......
	for( iloop=0; iloop<8; iloop++ )
	{
		look_SDA = data >> 7;
		data     = data << 1;
						for(x=z; x>0; x--){}
		look_SCL = 1;	for(x=z; x>0; x--){}
		look_SCL = 0;	for(x=z; x>0; x--){}
	}
	look_SDA = 0;		for(x=z; x>0; x--){}
	look_SCL = 1;		for(x=z; x>0; x--){}
	look_SCL = 0;		for(x=z; x>0; x--){}

//	stop condition......
	look_SDA = 0;		for(x=z; x>0; x--){}
	look_SCL = 1;		for(x=z; x>0; x--){}
	look_SDA = 1;		for(x=z; x>0; x--){}
}


void DVOB_init_and_try()
{
	P7FC.bit.b4   = 1;
	P7CR.bit.b4   = 1;
//	SYSCR1.bit.b4 = 1;		// DV9CK=1 for fs
	DVOCR.byte    = 0x00;	// setting DVOB register
	DVOCR.bit.b2  = 1;		// start DVOB output
}































